//****** CN131 SDK ******//
//*** SDK Information ***//
// Clock frequency: 80MHz
// Minimum clock frequency : 32MHz
// ADC sampling rate: 250Hz
// ADC resolution：12bit
// Power line frequency filter: 50Hz
// Optional medical standard ECG waveform
// Website: http://www.cyzur.com
// Mail: contactus@cyzur.com
// Release Date: 2023/8/4
// Version: VB.5
// Copyright(C) CyzurTech (Shanghai) Co. Ltd. 2020-
// All rights reserved

/****************************************** Cyzur SDK inlcude*********************************************/
#include "CN131_API.h"
#include <float.h>
/****************************************** user board function ******************************************/
void CN1xx_delay_us(uint32_t udelay)
{
}
// 脱落检查
uint8_t DB_LOD1_LOW(void)
{
	//	return (HAL_GPIO_ReadPin(DB_LOD1_GPIO_Port, DB_LOD1_Pin) == GPIO_PIN_RESET);
}
uint8_t DB_LOD1_HIGH(void)
{
	//	return (HAL_GPIO_ReadPin(DB_LOD1_GPIO_Port, DB_LOD1_Pin) == GPIO_PIN_SET);
	//	return 1;
}
// 复位CN131
void DB_RST_SET(void)
{
	//	HAL_GPIO_WritePin(DB_RST_GPIO_Port, DB_RST_Pin, GPIO_PIN_SET);
}
void DB_RST_RESET(void)
{
	//	HAL_GPIO_WritePin(DB_RST_GPIO_Port, DB_RST_Pin, GPIO_PIN_RESET);
}
// HARDWARE SPI
uint8_t CN1xx_SPI_ReadWrite(uint8_t *TxDataSeq, uint8_t *RxDataSeq, uint8_t SeqLen)
{
	//	HAL_SPI_TransmitReceive(&hspi1, TxDataSeq, RxDataSeq, SeqLen, HAL_MAX_DELAY);
	uint8_t hw_spi = 0; // if use hardware spi, make sure hw_spi = 1;
	return hw_spi;
}
// SOFTWARE SPI function
uint8_t DB_MISO_HIGH(void)
{
	//	return (HAL_GPIO_ReadPin(DB_MISO_GPIO_Port, DB_MISO_Pin) == GPIO_PIN_SET);
}
uint8_t DB_MISO_LOW(void)
{
	//	return (HAL_GPIO_ReadPin(DB_MISO_GPIO_Port, DB_MISO_Pin) == GPIO_PIN_RESET);
}
void DB_CSB_SET(void)
{
	//	HAL_GPIO_WritePin(DB_CSB_GPIO_Port, DB_CSB_Pin, GPIO_PIN_SET);
}
void DB_CSB_RESET(void)
{
	//	HAL_GPIO_WritePin(DB_CSB_GPIO_Port, DB_CSB_Pin, GPIO_PIN_RESET);
}
void DB_SCLK_SET(void)
{
	//	HAL_GPIO_WritePin(DB_SCLK_GPIO_Port, DB_SCLK_Pin, GPIO_PIN_SET);
}
void DB_SCLK_RESET(void)
{
	//	HAL_GPIO_WritePin(DB_SCLK_GPIO_Port, DB_SCLK_Pin, GPIO_PIN_RESET);
}
void DB_MOSI_SET(void)
{
	//	HAL_GPIO_WritePin(DB_MOSI_GPIO_Port, DB_MOSI_Pin, GPIO_PIN_SET);
}
void DB_MOSI_RESET(void)
{
	//	HAL_GPIO_WritePin(DB_MOSI_GPIO_Port, DB_MOSI_Pin, GPIO_PIN_RESET);
}
void SPI_ReadWrite(uint8_t *TxDataSeq, uint8_t *RxDataSeq, uint8_t SeqLen)
{
	uint8_t hw_spi = CN1xx_SPI_ReadWrite(TxDataSeq, RxDataSeq, SeqLen);
	if (hw_spi)
	{
		return;
	}
	uint8_t i = 0, j = 0, TxData = 0, RxData = 0;
	DB_CSB_RESET();
	CN1xx_delay_us(10);
	i = 0;
	while (i < SeqLen)
	{
		j = 0;
		TxData = TxDataSeq[i];
		while (j < 8)
		{
			DB_SCLK_SET();
			if (TxData & 0x80)
			{
				DB_MOSI_SET();
			}
			else
			{
				DB_MOSI_RESET();
			}
			TxData = TxData << 1;
			CN1xx_delay_us(2);
			DB_SCLK_RESET();
			RxData = RxData << 1;
			if (DB_MISO_HIGH())
			{
				RxData = RxData | 0x01;
			}
			else
			{
				RxData = RxData & 0xFE;
			}
			CN1xx_delay_us(2);
			j++;
		}
		RxDataSeq[i] = RxData;
		i++;
	}
	CN1xx_delay_us(10);
	DB_CSB_SET();
	CN1xx_delay_us(10);
}
// ADC采样
void ADC_START_IT(void)
{
	//	HAL_ADC_Start_IT(&hadc1);
}
void ADC_STOP_IT(void)
{
	//	HAL_ADC_Stop_IT(&hadc1);
}
uint32_t ADC_GETVALUE(void)
{
	//	return HAL_ADC_GetValue(&hadc1);
}
// 定时器中断
void TIM_BASE_START_IT(void)
{
	//	HAL_TIM_Base_Start_IT(&htim2);
}
void TIM_BASE_STOP_IT(void)
{
	//	HAL_TIM_Base_Stop_IT(&htim2);
}
/****************************************** Algorithms ****************************************************/
#ifndef CN131_ALGORITHM
int16_t CN131_ecg_filter(float input_ecg, uint16_t gain, int16_t *get_HR_input)
{
	*get_HR_input = 0;
	return (int16_t)input_ecg * 1000000.0f / gain;
}

int16_t CN131_get_HR(int16_t get_HR_input)
{
	return 0;
}

int16_t CN131_filter_init(void)
{
	return 0;
}

void CN131_get_HR_init(void)
{
	return;
}

uint16_t get_heart_Rate(void)
{
	return 0;
}
#endif
/****************************************** Cyzur SDK variable*********************************************/
uint16_t gain = 60;
volatile float adc_vol = 0;

volatile uint16_t heart_Rate = 0;

// CN131
static uint8_t autofr_force = 0;
static uint8_t config_reg = 0;
static uint8_t ch_set_reg = 0;
static uint16_t autofr_low_trig_cnt = 0;
static uint16_t autofr_high_trig_cnt = 0;
static uint16_t autofr_keep_cnt = 0;
static uint16_t leadon_judge_cnt = 0;
static uint16_t leadoff_judge_cnt = 0;
volatile uint8_t lod_status = LEAD_OFF;

FIFO_TypeDef fifo = {0};

static float VREF_T = 3.3;
static float VCM_T = 0.9;
// ADC
static uint32_t resolution_tmp = 1 << 12;

static float VH_LIMIT = 1.5;
static float VL_LIMIT = 0.3;

// para initial
static CN1xx_API_Para_t g_para = {
	.magic = 0xFA01,
	.res = {0},
	.work_mode = Health_MODE,
	.lead_status = LEAD_OFF,

	.version = {1, 0xA2} // 外控版本 v2.1
					  // 其他字段未显式初始化，默认为 0
};

/****************************************** Cyzur SDK function *********************************************/
void CN131_Parameter_Init(float *lp_parameter, ADC_RESOLUTION ADC_RESOLUTION_12, float VREF, float VVCM)
{
	VREF_T = VREF;
	VCM_T = VVCM;

	if (ADC_RESOLUTION_12 == ADC12BIT)
	{
		resolution_tmp = 1 << 12;
	}

	Copy_lp_oarameter(lp_parameter);
}

float ADC2Voltage(uint16_t adc)
{
	return (float)adc / resolution_tmp * VREF_T;
}

static void Check_Fifo_Error(void)
{
	if (FIFO_ERROR_LIMITER <= FIFO_Size())
	{
		g_para.error_code.bits.fifo_full_error = 1;
	}
}

uint8_t CN131_PowerOn()
{
	uint8_t opcode1 = OP_WREG | ADDR_CONFIG;
	uint8_t opcode2 = 0x00;
	uint8_t reg_data = config_reg;
	reg_data = reg_data & (~PWR_Mask);
	reg_data = reg_data & (~PWR_off);
	uint8_t TxDataSeq[3] = {opcode1, opcode2, reg_data};
	uint8_t RxDataSeq[3] = {0};

	SPI_ReadWrite(TxDataSeq, RxDataSeq, 3);

	opcode1 = OP_RREG | ADDR_CONFIG;
	opcode2 = 0x00;
	TxDataSeq[0] = opcode1;
	TxDataSeq[1] = opcode2;
	TxDataSeq[2] = 0xFF;

	SPI_ReadWrite(TxDataSeq, RxDataSeq, 3);

	if (RxDataSeq[2] == reg_data)
	{
		config_reg = reg_data;
		return 1;
	}
	else
	{
		return 0;
	}
}

uint8_t CN131_PowerOff()
{
	uint8_t opcode1 = OP_WREG | ADDR_CONFIG;
	uint8_t opcode2 = 0x00;
	uint8_t reg_data = config_reg;
	reg_data = reg_data & (~PWR_Mask);
	reg_data = reg_data | PWR_off;
	uint8_t TxDataSeq[3] = {opcode1, opcode2, reg_data};
	uint8_t RxDataSeq[3] = {0};

	SPI_ReadWrite(TxDataSeq, RxDataSeq, 3);

	opcode1 = OP_RREG | ADDR_CONFIG;
	opcode2 = 0x00;
	TxDataSeq[0] = opcode1;
	TxDataSeq[1] = opcode2;
	TxDataSeq[2] = 0xFF;

	SPI_ReadWrite(TxDataSeq, RxDataSeq, 3);

	if (RxDataSeq[2] == reg_data)
	{
		config_reg = reg_data;
		return 1;
	}
	else
	{
		return 0;
	}
}

uint8_t CN131_StandbyOn()
{
	uint8_t opcode1 = OP_WREG | ADDR_CONFIG;
	uint8_t opcode2 = 0x00;
	uint8_t reg_data = config_reg;
	reg_data = reg_data & (~STANDBY_Mask);
	reg_data = reg_data | STANDBY_on;
	uint8_t TxDataSeq[3] = {opcode1, opcode2, reg_data};
	uint8_t RxDataSeq[3] = {0};

	SPI_ReadWrite(TxDataSeq, RxDataSeq, 3);

	opcode1 = OP_RREG | ADDR_CONFIG;
	opcode2 = 0x00;
	TxDataSeq[0] = opcode1;
	TxDataSeq[1] = opcode2;
	TxDataSeq[2] = 0xFF;

	SPI_ReadWrite(TxDataSeq, RxDataSeq, 3);

	if (RxDataSeq[2] == reg_data)
	{
		config_reg = reg_data;
		return 1;
	}
	else
	{
		return 0;
	}
}

uint8_t CN131_StandbyOff()
{
	uint8_t opcode1 = OP_WREG | ADDR_CONFIG;
	uint8_t opcode2 = 0x00;
	uint8_t reg_data = config_reg;
	reg_data = reg_data & (~STANDBY_Mask);
	reg_data = reg_data & (~STANDBY_on);
	uint8_t TxDataSeq[3] = {opcode1, opcode2, reg_data};
	uint8_t RxDataSeq[3] = {0};

	SPI_ReadWrite(TxDataSeq, RxDataSeq, 3);

	opcode1 = OP_RREG | ADDR_CONFIG;
	opcode2 = 0x00;
	TxDataSeq[0] = opcode1;
	TxDataSeq[1] = opcode2;
	TxDataSeq[2] = 0xFF;

	SPI_ReadWrite(TxDataSeq, RxDataSeq, 3);

	if (RxDataSeq[2] == reg_data)
	{
		config_reg = reg_data;
		return 1;
	}
	else
	{
		return 0;
	}
}

uint8_t CN131_FR_On()
{
	uint8_t opcode1 = OP_WREG | ADDR_CH_SET;
	uint8_t opcode2 = 0x00;
	uint8_t reg_data = ch_set_reg;
	reg_data = reg_data & (~FR_Mask);
	reg_data = reg_data | FR_on;
	uint8_t TxDataSeq[3] = {opcode1, opcode2, reg_data};
	uint8_t RxDataSeq[3] = {0};

	SPI_ReadWrite(TxDataSeq, RxDataSeq, 3);

	opcode1 = OP_RREG | ADDR_CH_SET;
	opcode2 = 0x00;
	TxDataSeq[0] = opcode1;
	TxDataSeq[1] = opcode2;
	TxDataSeq[2] = 0xFF;

	SPI_ReadWrite(TxDataSeq, RxDataSeq, 3);

	if (RxDataSeq[2] == reg_data)
	{
		ch_set_reg = reg_data;
		return 1;
	}
	else
	{
		return 0;
	}
}

uint8_t CN131_FR_Off()
{
	uint8_t opcode1 = OP_WREG | ADDR_CH_SET;
	uint8_t opcode2 = 0x00;
	uint8_t reg_data = ch_set_reg;
	reg_data = reg_data & (~FR_Mask);
	reg_data = reg_data & (~FR_on);
	uint8_t TxDataSeq[3] = {opcode1, opcode2, reg_data};
	uint8_t RxDataSeq[3] = {0};

	SPI_ReadWrite(TxDataSeq, RxDataSeq, 3);

	opcode1 = OP_RREG | ADDR_CH_SET;
	opcode2 = 0x00;
	TxDataSeq[0] = opcode1;
	TxDataSeq[1] = opcode2;
	TxDataSeq[2] = 0xFF;

	SPI_ReadWrite(TxDataSeq, RxDataSeq, 3);

	if (RxDataSeq[2] == reg_data)
	{
		ch_set_reg = reg_data;
		return 1;
	}
	else
	{
		return 0;
	}
}

uint8_t CN131_Set_Gain(uint8_t gain)
{
	uint8_t opcode1 = OP_WREG | ADDR_CH_SET;
	uint8_t opcode2 = 0x00;
	uint8_t reg_data = ch_set_reg;
	reg_data = reg_data & (~GAIN_Mask);
	reg_data = reg_data | gain;
	uint8_t TxDataSeq[3] = {opcode1, opcode2, reg_data};
	uint8_t RxDataSeq[3] = {0};

	SPI_ReadWrite(TxDataSeq, RxDataSeq, 3);

	opcode1 = OP_RREG | ADDR_CH_SET;
	opcode2 = 0x00;
	TxDataSeq[0] = opcode1;
	TxDataSeq[1] = opcode2;
	TxDataSeq[2] = 0xFF;

	SPI_ReadWrite(TxDataSeq, RxDataSeq, 3);

	if (RxDataSeq[2] == reg_data)
	{
		ch_set_reg = reg_data;
		return 1;
	}
	else
	{
		return 0;
	}
}

uint8_t CN131_Set_Bandwidth(uint8_t hp, uint8_t lp)
{
	uint8_t opcode1 = OP_WREG | ADDR_CH_SET;
	uint8_t opcode2 = 0x00;
	uint8_t reg_data = ch_set_reg;
	reg_data = reg_data & (~HP_Mask);
	reg_data = reg_data | hp;
	reg_data = reg_data & (~LP_Mask);
	reg_data = reg_data | lp;
	uint8_t TxDataSeq[3] = {opcode1, opcode2, reg_data};
	uint8_t RxDataSeq[3] = {0};

	SPI_ReadWrite(TxDataSeq, RxDataSeq, 3);

	opcode1 = OP_RREG | ADDR_CH_SET;
	opcode2 = 0x00;
	TxDataSeq[0] = opcode1;
	TxDataSeq[1] = opcode2;
	TxDataSeq[2] = 0xFF;

	SPI_ReadWrite(TxDataSeq, RxDataSeq, 3);

	if (RxDataSeq[2] == reg_data)
	{
		ch_set_reg = reg_data;
		return 1;
	}
	else
	{
		return 0;
	}
}

uint8_t CN131_AutoFR_Trig(float adc_vol)
{
    if (adc_vol < VL_LIMIT)
    {
        autofr_low_trig_cnt++;
        autofr_high_trig_cnt = 0;
    }
    else if (adc_vol > VH_LIMIT)
    {
        autofr_high_trig_cnt++;
        autofr_low_trig_cnt = 0;
    }
    else
    {
        autofr_low_trig_cnt = 0;
        autofr_high_trig_cnt = 0;
    }
    if (autofr_low_trig_cnt > AUTOFR_LOW_TRIG_LIMIT || autofr_high_trig_cnt > AUTOFR_HIGH_TRIG_LIMIT)
    {
        return 1;
    }
    else
    {
        return 0;
    }
}

FR_STATUS CN131_AutoFR(CN131_FR_MODE mode, float adc_vol_det)
{
    int result = 0;
    if (autofr_keep_cnt > 0)
    {
        autofr_keep_cnt++;
		if (autofr_keep_cnt > AUTOFR_KEEP_LIMIT)
		{
			result = CN131_FR_Off();
			if (!result)
			{
				g_para.error_code.bits.spi_write_read_error = 1;
			}
			g_para.auto_fr_status = FR_TIMEOUT_RELEASED;
            //重置自动触发计次
            autofr_low_trig_cnt = 0;
            autofr_high_trig_cnt = 0;
			autofr_keep_cnt = 0;
			autofr_force = 0;
			return FR_TIMEOUT_RELEASED;
		}
    }
    if (mode == FORCE_FR)
    {
        autofr_force = 1;
        result = CN131_FR_On();
        if (!result)
        {
            g_para.error_code.bits.spi_write_read_error = 1;
        }
        adc_vol = adc_vol_det;
        autofr_keep_cnt = 1;
        return 1;
    }
    else if (autofr_force == 0 && CN131_AutoFR_Trig(adc_vol_det))
    {
        result = CN131_FR_On();
        if (!result)
        {
            g_para.error_code.bits.spi_write_read_error = 1;
        }
        autofr_keep_cnt = 1;
        return 1;
    }

    return 0;
}
// 脱落检测 增加宏定义可配置到头文件
void CN131_LOD_Detect(void)
{
	if (DB_LOD1_LOW())
	{
		leadon_judge_cnt++;
		if (leadon_judge_cnt >= LEADON_JUDGE_LIMIT)
		{
			lod_status = LEAD_ON;
			g_para.lead_status = LEAD_ON;
			leadon_judge_cnt = 0;
		}
	}
	else
	{
		leadon_judge_cnt = 0;
	}
	// 新加
	if (DB_LOD1_HIGH())
	{
		leadoff_judge_cnt++;
		if (leadoff_judge_cnt >= LEADOFF_JUDGE_LIMIT)
		{
			lod_status = LEAD_OFF;
			g_para.lead_status = LEAD_OFF;
			leadoff_judge_cnt = 0;
		}
	}
	else
	{
		leadoff_judge_cnt = 0;
	}
	// 新加到此结束
}

void CN131_Reset(void)
{
	DB_RST_SET();
	CN1xx_delay_us(1);
	DB_RST_RESET();

	config_reg = 0;
	ch_set_reg = 0;
}

uint8_t FIFO_Push(float val)
{
	if (fifo.full == 1)
		return 1;
	Check_Fifo_Error();
	fifo.buf[fifo.pos_write++] = val;
	fifo.pos_write %= FIFO_Depth;
	fifo.fifolength++;
	if (fifo.pos_write == fifo.pos_read)
	{
		fifo.full = 1;
	}
	return 0;
}

uint8_t FIFO_Pop(float *val)
{
	if (fifo.full == 0 && fifo.pos_read == fifo.pos_write)
		return 1;

	*val = fifo.buf[fifo.pos_read++];
	fifo.fifolength--;
	fifo.pos_read %= FIFO_Depth;
	fifo.full = 0;
	return 0;
}

void FIFO_Clear()
{
	memset(&fifo, 0, sizeof(FIFO_TypeDef));
}

uint8_t FIFO_Full()
{
	return fifo.full;
}

uint16_t FIFO_Size()
{
	return fifo.fifolength;
}

uint8_t CN131_Init(CN131_WORKMODE Work_mode)
{
	switch (Work_mode)
	{
	case (Medical_MODE):
		g_para.work_mode = Medical_MODE;
		g_para.hp = HP_0p05;
		g_para.lp = LP_300;
		g_para.gain = GAIN_120;
		gain = 120;
		break;
	case (Health_MODE):
		g_para.work_mode = Health_MODE;
		g_para.hp = HP_4;
		g_para.gain = GAIN_120;
		gain = 120;		   // H
		g_para.lp = LP_55; // 芯片滤波
		break;
	default:
		g_para.hp = HP_0p05;
		g_para.lp = LP_300;
		g_para.gain = GAIN_120;
		break;
	}

	CN131_Reset();
    uint8_t result1 = CN131_PowerOn();
    CN1xx_delay_us(2000);
    uint8_t result2 = CN131_StandbyOff();
    CN1xx_delay_us(2000);
    uint8_t result3 = CN131_FR_Off();
    CN1xx_delay_us(2000);
    uint8_t result4 = CN131_Set_Gain(g_para.gain);
    CN1xx_delay_us(2000);
    uint8_t result5 = CN131_Set_Bandwidth(g_para.hp, g_para.lp);
    uint8_t result = (result1 && result2 && result3 && result4 && result5);
	if (0 == result)
	{
		gain = 60;
		g_para.gain = GAIN_60;
		g_para.error_code.bits.spi_write_read_error = 1;
	}
	return result;
}

uint8_t CN131_Standby(void)
{
	return (CN131_PowerOn() && CN131_StandbyOn() && CN131_FR_Off());
}

void CN131_Start(void)
{
}

void CN131_LOD_ON_Init(CN131_LOD_On_MODE init_mode)
{
	FIFO_Clear();
	CN131_AutoFR(FORCE_FR, 0.9);
	if (init_mode == realRhythm)
	{
		QRSDet_V2_init();
	}
}

uint8_t CN131_Data_Proc(CN131_PROC CN131_proc, int16_t *ecg, int16_t *RDelay)
{
	uint8_t result = 0;
    uint16_t adc_value = 0;
	int16_t HR_input = 0;
	float adc_value_real = 0;
	switch (CN131_proc)
	{
	case (LOD_IT_PROC):
		CN131_LOD_Detect();
		break;
	case (ADC_IT_PROC):
		adc_vol = ADC2Voltage(*ecg);
        result = FIFO_Push(*ecg);
		g_para.adc_vol_det = adc_vol;
		g_para.auto_fr_status = CN131_AutoFR(AUTO_FR, adc_vol);
		break;
	case (GET_VALUE_PROC):
		// 改动fifo为uint16
        result = FIFO_Pop(&adc_value);
        adc_value_real = ADC2Voltage(adc_value);
		if (0 == result)
		{
			int16_t ecg_norm = CN131_ecg_filter(-(adc_value_real - VCM_T), gain, &HR_input);
			*ecg = ecg_norm > 0.0f ? (int16_t)(ecg_norm + 0.5f) : (int16_t)(ecg_norm - 0.5f);
		}
		if (FIFO_Full())
		{
			result = 2;
		}
		break;
	case (GET_VALUE_Rdet_PROC):
        // 改动fifo为uint16
        result = FIFO_Pop(&adc_value);
        adc_value_real = ADC2Voltage(adc_value);
		if (0 == result)
		{
			int16_t ecg_norm = CN131_ecg_filter(-(adc_value_real - VCM_T), gain, &HR_input);
			*ecg = ecg_norm > 0.0f ? (int16_t)(ecg_norm + 0.5f) : (int16_t)(ecg_norm - 0.5f);
			*RDelay = CN131_get_HR(HR_input);
		}
		if (FIFO_Full())
		{
			result = 2;
		}

		break;
	default:
		break;
	}
	return result;
}

uint8_t CN131_Stop(void)
{
	return (CN131_PowerOff());
}

uint32_t Get_CN1xx_parameter(CN1xx_API_Para_t *parameter)
{
	memcpy(parameter, &g_para, sizeof(CN1xx_API_Para_t));
	return sizeof(CN1xx_API_Para_t);
}
